<?php

namespace Tests\Unit;

use Tests\TestCase;
use Illuminate\Support\Facades\Session;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Foundation\Testing\DatabaseTransactions;

class UserNewsletterTest extends TestCase
{

    use WithFaker;

    use DatabaseTransactions;

    protected function setUp(): void
    {
        parent::setUp();
        // to see description
        $this->withoutExceptionHandling();

        // Start session to enables csrf_token()
        Session::start();
    }
    /**
     * A basic unit test example.
     *
     * @return void
     */
    public function testUserCanCreateNewsletter()
    {

        $email = $this->faker->unique()->email;
        $response= $this->post(route('userNewsletters.store'),
            array_merge( ['email' => $email], ['_token'=> csrf_token()] ) );

        $response->assertStatus(200);
        $response->assertSee(true);

    }
}
