<?php $__env->startSection('content'); ?>

    <section class="contact-pg section bg-babyBlue">
        <div class="container">
            <div class="inner bg-white wow left_to_right_apperance">
                <div class="row align-items-end justify-content-between">
                    <div class="head mb-5 col-lg-12">
                        <h1 class="title mb-4 color-dark fw-bold"><?php echo e($contactUsTitle1); ?> <br> <span class="color-primary"><?php echo e($contactUsTitle2); ?></span></h1>
                        <p class="det"><?php echo $contactUsPage->description; ?></p>
                    </div>
                </div>
                <div class="row">
                    <?php if($settings['site_phone'] ?? null): ?>
                    <div class="col-lg-4">
                        <div class="contact_card inFlex mb-3">
                            <div class="icon_outer">
                                <img src="<?php echo e(asset('assets/web/images/icons/contact-1.svg')); ?>" alt="" class="icon"/>
                            </div>
                            <div class="content">
                                <h5 class="title"><?php echo e(__('settings.phone')); ?></h5>
                                <p class="p mb-0"><?php echo e($settings['site_phone']); ?></p>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php if($settings['site_email'] ?? null): ?>
                    <div class="col-lg-4">
                        <div class="contact_card inFlex mb-3">
                            <div class="icon_outer">
                                <img src="<?php echo e(asset('assets/web/images/icons/contact-2.svg')); ?>" alt="" class="icon"/>
                            </div>
                            <div class="content">
                                <h5 class="title"><?php echo e(__('settings.email')); ?></h5>
                                <p class="p mb-0"><?php echo e($settings['site_email']); ?></p>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php if($settings['site_address_'.$lang] ?? null): ?>
                    <div class="col-lg-4">
                        <div class="contact_card inFlex mb-3">
                            <div class="icon_outer">
                                <img src="<?php echo e(asset('assets/web/images/icons/contact-3.svg')); ?>" alt="" class="icon"/>
                            </div>
                            <div class="content">
                                <h5 class="title"><?php echo e(__('settings.address')); ?></h5>
                                <p class="p mb-0"><?php echo e($settings['site_address_'.$lang]); ?></p>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
    <!-- Start contact-sec -->
    <section class="contact-sec section">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="sec-head mb-5 wow fadeInUp">
                        <h1 class="title color-dark fw-bold mb-4 text-capitalize">
                            <?php echo e($aboutUsTitle1); ?> <br> <span class="color-primary"><?php echo e($aboutUsTitle2); ?></span>
                        </h1>
                        <div class="desc_container">
                            <?php echo wordLimit($aboutUsPage->description, 21); ?>

                        </div>
                        <div class="hours-box mt-5">
                            <h5 class="title color-dark mb-4"><b><?php echo e(__('workHours.appointment')); ?></b></h5>
                            <div class="row">
                                <div class="col-6">
                                    <?php $__currentLoopData = $workHours[0]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $workHour): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="day_item">
                                            <span class="day"><?php echo e(__('workHours.'.$workHour['week_day'])); ?></span> :
                                            <?php if($workHour['status'] == 'open'): ?>
                                                <span class="time">
                                                    <?php
                                                    /** @var TYPE_NAME $workHour */
                                                    $timeFrom = date('h A', strtotime($workHour['time_from']));
                                                    $timeTo = date('h A', strtotime($workHour['time_to']));

                                                    $timeFrom = strpos($timeFrom, 'AM') ? date('h ', strtotime($timeFrom)) . __('workHours.am') : date('h ', strtotime($timeFrom)) . __('workHours.pm');
                                                    $timeTo = strpos($timeTo, 'AM') ? date('h ', strtotime($timeTo)) . __('workHours.am') : date('h ', strtotime($timeTo)) . __('workHours.pm');
                                                    ?>
                                                    <?php echo e($timeFrom . ' - ' . $timeTo); ?>

                                                </span>
                                            <?php endif; ?>
                                            <?php if($workHour['status'] == 'closed'): ?>
                                                <span class="time text-danger"><?php echo e(__('workHours.closed')); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </div>
                                <div class="col-6">
                                    <?php $__currentLoopData = $workHours[1]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $workHour): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="day_item">
                                            <span class="day"><?php echo e(__('workHours.'.$workHour['week_day'])); ?></span> :
                                            <?php if($workHour['status'] == 'open'): ?>
                                                <span class="time">
                                                    <?php
                                                    /** @var TYPE_NAME $workHour */
                                                    $timeFrom = date('h A', strtotime($workHour['time_from']));
                                                    $timeTo = date('h A', strtotime($workHour['time_to']));

                                                    $timeFrom = strpos($timeFrom, 'AM') ? date('h ', strtotime($timeFrom)) . __('workHours.am') : date('h ', strtotime($timeFrom)) . __('workHours.pm');
                                                    $timeTo = strpos($timeTo, 'AM') ? date('h ', strtotime($timeTo)) . __('workHours.am') : date('h ', strtotime($timeTo)) . __('workHours.pm');
                                                    ?>
                                                    <?php echo e($timeFrom . ' - ' . $timeTo); ?>

                                                </span>
                                            <?php endif; ?>
                                            <?php if($workHour['status'] == 'closed'): ?>
                                                <span class="time text-danger"><?php echo e(__('workHours.closed')); ?></span>
                                            <?php endif; ?>
                                        </div>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="map-box wow left_to_right_apperance map_container">
                        <?php echo $settings['site_map']; ?>

                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Start Jobs-pg -->
    <section class="jobs-det section bg-babyBlue">
        <div class="container">
            <div class="box mt-0 w-100 shadow-none wow left_to_right_apperance">
                <div class="contact-pg">
                    <div class="head mb-5 ">
                        <h1 class="title mb-4 color-dark fw-bold text-capitalize"><?php echo e($contactFormTitle1); ?> <span class="color-primary"><?php echo e($contactFormTitle2); ?></span></h1>
                    </div>
                </div>
                <form method="post" action="<?php echo e(route('contact.store')); ?>" class="contact_us_form">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label class="label"><?php echo e(__('visitorMessages.name')); ?></label>
                                <input type="text" name="name" class="form-control" placeholder="<?php echo e(__('visitorMessages.name')); ?>">
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label class="label"><?php echo e(__('visitorMessages.email')); ?></label>
                                <input type="email" name="email" class="form-control" placeholder="<?php echo e(__('visitorMessages.email')); ?>">
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label class="label"><?php echo e(__('visitorMessages.phone')); ?></label>
                                <input typeof="tel" name="phone" class="form-control" placeholder="<?php echo e(__('visitorMessages.phone')); ?>">
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label class="label"><?php echo e(__('visitorMessages.subject')); ?></label>
                                <input name="subject" class="form-control" placeholder="<?php echo e(__('visitorMessages.subject')); ?>">
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label class="label"><?php echo e(__('visitorMessages.message')); ?></label>
                                <textarea name="message" class="form-control" placeholder="<?php echo e(__('visitorMessages.message')); ?>" rows="5"></textarea>
                            </div>
                        </div>
                        <div class="col-lg-3 mt-5 m-auto">
                            <button class="butn primary_butn w-100 contact_us_button">
                                <b><?php echo e(__('main.send')); ?></b>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('inner_js'); ?>

    <script>

        $('.contact_us_button').click(async function (e) {
            e.preventDefault();

            $(this).prop('disabled', true);

            let form = $('.contact_us_form'),
                data = new FormData(form[0]),
                url = form.attr('action'),
                method = form.attr('method');

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method
            });

            if (response.errors){
                $(this).prop('disabled', false);
                toasterError(response.errors);
            }

            if (response.message){
                toasterSuccess(response.message);
                $('input, textarea').val('');
            }

        });

        $(document).ready(function () {
            $('.map_container iframe').attr('width', '100%').attr('height', '550')
        })
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('web.layouts.container', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/procarecom/public_html/resources/views/web/contacts/index.blade.php ENDPATH**/ ?>