@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row" method="post" action="{{ $action }}" enctype="multipart/form-data">
        @if($websiteCategory ?? ''  && $websiteCategory->id)
            @method('PUT')
        @endif
        @csrf

        <div class="form-group col-lg-6">
            <label>{{ meta('name', $lang) ?? __('websiteCategories.name') }}</label>
            <input type="text" class="form-control {{ $errors->has('name_'.$lang) ? 'is-invalid' : '' }}" name="name_{{ $lang }}" placeholder="{{ meta('name', $lang) ?? __('websiteCategories.name') }}" value='{{ old("name_".$lang, $websiteCategory ?? '' ? descriptions($websiteCategory)->name ?? null : "") }}'/>
        </div>

        <div class="form-group col-lg-6">
            <label>{{ meta('slug', $lang) ?? __('websiteCategories.slug') }} </label>
            <input type="text" class="form-control {{ $errors->has('slug_'.$lang) ? 'is-invalid' : '' }}" name="slug_{{ $lang }}" placeholder="{{ meta('slug', $lang) ?? __('websiteCategories.slug') }}" value='{{ old("slug_".$lang, $websiteCategory ?? '' ? descriptions($websiteCategory)->slug ?? null : "") }}'/>
        </div>
        <div class="border-item photos col-md-12">
            <div class="row">
                @if ($websiteCategory ?? false)
                    @foreach ($websiteCategory['photos'] as $photo)
                        <div class="col-md-6">
                            <div class="items">
                                <div class="img">
                                    <a href="{{ asset($photo->image ?? '')}}" data-fancybox="gallery"><img src="{{ asset($photo->image ?? '')}}" alt=""></a>
                                </div>
                                <div class="info">
                                    <div class="img-title">
                                        <input type="text" name="image_title_{{$lang}}[]"  placeholder="{{ meta('image_title', $lang) ?? __('websiteCategories.title') }}" value="{{ descriptions($photo)->title ?? "" }}">
                                        <input type="text" name="image_url[]"  placeholder="{{ meta('image_url', $lang) ?? __('websiteCategories.url') }}" value="{{ $photo->url ?? "" }}">
                                        <input type="hidden" name="images[]" value="{{ $photo->image ?? "" }}">
                                        <span class="preview"> </span>
                                    </div>
                                </div>
                                <a href="#" class="close"><i class="fas fa-times"></i></a>
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>
            <div class="text-center">
                <input id="website_gallery_photo_thumbnail" class="website_gallery_photo_thumbnail" type="hidden"/>
                <div class="clearfix"></div>
                <span id="add">
                <a id="lfm" data-cache="website_gallery_photos" data-title="true" data-url="true" data-width="col-md-6" data-input=".website_gallery_photo_thumbnail" data-preview=".website_gallery_photo_thumbnail" data-show="" data-hide="" class="lfm add">
                    {{meta('new_item', $lang ?? 'Add New Item')}}
                </a>
            </span>
            </div>
        </div>

        <div class="text-center mt-5 col-12">
            <button class="butn"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
    <!-- Editor JS files -->
        <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
{{--    <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            currentLanguage = "{{$lang}}",
            imageTitle = "{{meta('image_title', $lang) ?? null}}",
            imageUrl = "{{meta('image_url', $lang) ?? null}}",
            imagePath = "{{asset('')}}",
            inputName = null;
    </script>
    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>
    <script src="{{ asset('assets/admin/js/website_galleries.js') }}"></script>

@endsection



