@foreach($videoCategories as $key=> $row)
<tr>
    <th scope="row">
        <div class="custom-control custom-checkbox">
            <input type="checkbox" class="custom-control-input selectOne deleteCheck" id="customCheck{{$row->id}}" value="{{$row->id}}" name="id[]">
            <label class="custom-control-label" for="customCheck{{$row->id}}">{{-- $row->id --}}</label>
        </div>
    </th>
    <td>{{ $row->name }}</td>
    <td colspan="2">{{ \Carbon\Carbon::parse($row->created_at)->format('Y/m/d') }}</td>
    <td>
        @if($row->deleted_at)
            <a href="{{ route ('videoCategories.restore', $row->id) }}" data-method="put" class="icon rowAction" title="{{ __('dashboard.restore') }}"><img src="{{ asset('assets/admin/images/icons/restore.svg') }}" alt="{{ __('dashboard.restore') }}"></a>

            <a href="{{ route ('videoCategories.destroy', $row->id) }}" data-method="delete" class="icon rowAction" title="{{ __('dashboard.delete') }}"><img src="{{ asset('assets/admin/images/icons/close.svg') }}" alt="{{ __('dashboard.delete') }}"></a>
        @else
            <a href="{{ route ('videoCategories.edit', $row->id) }}" class="icon" title="{{ __('dashboard.edit') }}"><img src="{{ asset('assets/admin/images/icons/draw.svg') }}" alt="{{ __('dashboard.edit') }}"></a>

            <a href="{{ route ('videoCategories.destroy', $row->id) }}" data-method="delete" class="icon rowAction" title="{{ __('dashboard.trash') }}"><img src="{{ asset('assets/admin/images/icons/del.svg') }}" alt="{{ __('dashboard.trash') }}"></a>
        @endif
    </td>
</tr>
@endforeach

@if( count( $videoCategories ) && $videoCategories->hasPages() )
<tr> <td></td><td> {{ $videoCategories->links() }} </td> </tr>
@endif
