@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="{{ $action }}" enctype="multipart/form-data">
        @if($partner ?? ''  && $partner->id)
            @method('PUT')
        @endif
        @csrf


        <div class="form-group col-lg-3">
            <label>{{ meta('type', $lang) ?? __('partners.type') }} </label>
            <select name="type" class="form-control {{ $errors->has('type') ? 'is-invalid' : '' }}">
                <option {{old('type', $partner->type ?? null) == 'partner' ? 'selected' : '' }} value="partner">{{__('partners.partner')}}</option>
                <option {{old('type', $partner->type ?? null) == 'insurance' ? 'selected' : '' }} value="insurance">{{__('partners.insurance')}}</option>
            </select>
        </div>
        <div class="form-group col-lg-9">
            <label>{{ meta('url', $lang) ?? __('partners.url') }} </label>
            <input type="url"  class="form-control {{ $errors->has('url') ? 'is-invalid' : '' }}" name="url" placeholder="{{ meta('url', $lang) ?? __('partners.url') }}" value='{{ old("url", $partner->url ?? "") }}'/>
        </div>

        @foreach(languages() as $language)
        <div class="form-group col-lg-6">
            <label>{{ meta('name', $language->local) ?? __('pages.name') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
            <input type="text" class="form-control {{ $errors->has('name_'.$language->local) ? 'is-invalid' : '' }}" name="name_{{ $language->local }}" placeholder="{{ meta('name', $language->local) ?? __('pages.name') }}" value='{{ old("name_{$language->local}", $partner[$language->local]->name ?? "") }}'/>
        </div>

{{--        <div class="form-group col-lg-6">--}}
{{--            <label>{{ meta('slug', $language->local) ?? __('pages.slug') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>--}}
{{--            <input type="text" class="form-control {{ $errors->has('slug_'.$language->local) ? 'is-invalid' : '' }}" name="slug_{{ $language->local }}" placeholder="{{ meta('slug', $language->local) ?? __('pages.slug') }}" value='{{ old("slug_{$language->local}", $partner[$language->local]->slug ?? "") }}'/>--}}
{{--        </div>--}}

{{--        <div class="form-group col-lg-12">--}}
{{--            <label>{{ meta('keywords', $language->local) ?? __('pages.keywords') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>--}}
{{--            <input type="text" class="form-control {{ $errors->has('keywords_'.$language->local) ? 'is-invalid' : '' }}" name="keywords_{{ $language->local }}" placeholder="{{ meta('keywords', $language->local) ?? __('pages.keywords') }}" value='{{ old("keywords_{$language->local}", $partner[$language->local]->keywords ?? "") }}'/>--}}

{{--        </div>--}}

{{--        <div class="form-group col-lg-12">--}}
{{--            <label>{{ meta('meta_description', $language->local) ?? __('pages.meta_description') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>--}}
{{--            <input type="text" class="form-control {{ $errors->has('meta_description_'.$language->local) ? 'is-invalid' : '' }}" name="meta_description_{{ $language->local }}" placeholder="{{ meta('meta_description', $language->local) ?? __('pages.meta_description') }}" value='{{ old("meta_description_{$language->local}", $partner[$language->local]->meta_description ?? "") }}'/>--}}
{{--        </div>--}}

{{--        <div class="form-group col-lg-12">--}}
{{--            <label>{{ meta('description', $language->local) ?? __('pages.description') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>--}}
{{--            <textarea name="description_{{ $language->local }}" class="form-control my-editor {{ $errors->has('description_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('description', $language->local) ?? __('pages.description') }}">{!! old("description_{$language->local}", $partner[$language->local]->description ?? "") !!}</textarea>--}}
{{--        </div>--}}

        @endforeach



        {{--Start image container--}}
        <div class="form-group col-lg-12">
            <label>{{ meta('image', getCurrentLocale()) ?? __('pages.image') }} </label>
            <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="{{old("image", $partner->image ?? "")}}"/>

            <div class="photos main_photo {{ old('image', $partner->image ?? '') ? ' wow fadeInUp' : 'hide' }}">
                <div class="col-lg-4">
                    <div class="items">
                        <div class="img">
                            <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                <img src="{{asset(old('image', $partner->image ?? ''))}} "  id="image_holder" class="image_holder"/>
                            </a>
                        </div>
                        <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                    </div>
                </div>
            </div>

            <div class="clearfix"></div>
            <span class="input-group-btn pick_button {{ old('image', $partner->image ?? '') ? 'hide' : '' }} ">
                <a id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> Choose
                </a>
            </span>
        </div>
        {{--End image container--}}

        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')
    <!-- Editor JS files -->
        <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
{{--    <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        var route_prefix = "{{ url(config('lfm.prefix')) }}";
        var url = "{{url('/')}}/",
            currentLanguage = "{{getCurrentLocale()}}",
            inputName = '';
    </script>
    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>

    <script>
        sendAjax('.add_button', '.add_form')
    </script>

@endsection



