@extends('admin.layouts.layout')

@section('container_content')
    @include('admin.layouts.menu')

    <!--Contents-->
    <main class="main">
        <!-- ------------ top nav ------------- -->
    <section class="top-nav d-flex justify-content-between">

        @if(getCurrentLocale() == 'ar')
            <a class="butn btn_line" href="{{LaravelLocalization::getLocalizedURL('en', null, [], true)}}">
                <span> <i class="fas fa-globe"></i> {{__('main.another_lang')}} </span>
            </a>
        @endif
        @if(getCurrentLocale() == 'en')
            <a class="butn btn_line" href="{{LaravelLocalization::getLocalizedURL('ar', null, [], true)}}">
                <span> <i class="fas fa-globe"></i> {{__('main.another_lang')}} </span>
            </a>
        @endif

        <a class="butn btn_line" href="{{ route('admin_logout') }}" onclick="event.preventDefault();document.getElementById('logout-form').submit();">
            <span> <i class="fas fa-sign-out-alt"></i> {{ __('dashboard.logout') }} </span>
        </a>
        <form id="logout-form" action="{{ route('admin_logout') }}" method="POST" style="display: none;">
            @csrf
        </form>
    </section>
        @if(count($errors))
            <div class="alert alert-danger">
                @foreach($errors->all() as $error)
                    <li>
                        {{$error}}
                    </li>
                @endforeach
            </div>
        @endif

        @if (session('message'))
            <div class="alert alert-success message_alert">{{session('message')}}</div>
        @endif

        <div class="alert alert-danger ajaxErrorResponse" style="display: none"></div>
        <div class="alert alert-success ajaxResponse" style="display: none"></div>

    <!-- Response of ajax requests -->


        @yield('content')
    </main>

    <!--Footer-->
    <footer class="">
        <div class="loading hide">
            <div class="loader"></div>
        </div>
    </footer>
    <!--End-Footer-->

@endsection

@section('container_js')
    {{--    <script src="https://unpkg.com/axios/dist/axios.min.js"></script>--}}
    <script src="{{ asset('assets/admin/js/lib/axios.min.js') }}"></script>

    <script>
        axios.defaults.headers.common = {
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-TOKEN' : document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        };
    </script>
    <script src="{{ asset('assets/admin/js/actions.js') }}"></script>
    @yield('inner_js')
@endsection
