@extends('admin.layouts.container')

@section('content')
<form>
<div class="side-title">
    <div class="row">
        <div class="col-lg-6">
            <h3>{{ $title }}</h3>
        </div>
        <div class="col-lg-6 valign">
            <div class="edit-buttons text-right w-100">
                <a href="{{ route ('countries.destroyAll') }}" data-method="delete" class="butn statusButns status_1 tableAction btn disabled bg-warning"> <span>{{ __('dashboard.sendToTrash') }}</span></a>
                <a href="#" class="butn statusButns status_1 showArchive bg-primary"> <span> {{ __('dashboard.displayTrash') }} </span></a>

{{--                <a href="{{ route ('countries.destroyAll') }}" data-method="delete" class="butn statusButns status_0 tableAction btn disabled bg-danger force"> <span> {{ __('dashboard.delete') }} </span></a>--}}
{{--                <a href="{{ route ('countries.restoreAll') }}" data-method="put" class="butn statusButns status_0 tableAction btn disabled bg-info"> <span> {{ __('dashboard.restore') }} </span></a>--}}
                <a href="#" class="butn statusButns status_0 showActive bg-primary"> <span> {{ __('dashboard.displayActive') }} </span></a>
            </div>
        </div>
    </div>
</div>

<!-- ------------ data table ------------- -->
<table class="table table-hover table-bordered">
    <thead>
        <tr>
            <th scope="col">
            <div class="custom-control custom-checkbox">
                <input type="checkbox" class="custom-control-input" id="selectall" name="example1">
                <label class="custom-control-label" for="selectall"> </label>
            </div>
            </th>
            <th scope="col">{{ __('countries.name') }}</th>
{{--            <th scope="col">{{ __('countries.code') }}</th>--}}
            <th scope="col" colspan="2">{{ __('dashboard.created_at') }}</th>
            <th scope="col">{{ __('dashboard.processes') }}</th>
        </tr>
    </thead>

    <tbody class="response">
        <tr class="search_filter_form">
            <th scope="row"></th>
            <th scope="row">
                <input type="text" name="name" value="{{ $request->name ?? '' }}" class="form-control" placeholder="">
            </th>
{{--            <th scope="row">--}}
{{--                <input type="text" name="code" value="{{ $request->code ?? '' }}" class="form-control" placeholder="">--}}
{{--            </th>--}}
            <td>
                <input type="text" placeholder="{{ __('dashboard.date_from') }}" name="date_from" value="{{ $request->date_from ?? '' }}" class="date_from form-control">
            </td>
            <td>
                <input type="text" placeholder="{{ __('dashboard.date_to') }}" name="date_to" value="{{ $request->date_to ?? '' }}" class="date_to form-control">
            </td>
            <th scope="col"><button type="button" class="butn color small search"><span><i class="fas fa-search"></i></span></button></th>
        </tr>
    </tbody>


</table>
<!-- ------------ sidemenu links ------------- -->
</form>
@endsection



<script>
/**
 * Importat to handle ajax requests for filters, deletes, trash and any proccess done on the table's data
 */
var dataTable={
    route: '{{ route("countries.grid") }}'
}
</script>
@section('inner_js')

@endsection
