@extends('admin.layouts.container')

@section('content')
<div class="side-title">
    <h3>{{$head ?? '' }}</h3>
</div>

<div class="border-item">
    <form class="form-row add_form" method="post" action="{{ $action }}" enctype="multipart/form-data">
        @if($conference ?? ''  && $conference->id)
            @method('PUT')
        @endif
        @csrf

            <div class="form-group col-lg-6">
                <label>{{ meta('start_date', $lang) ?? __('conferences.start_date') }} </label>
                <input type="date" class="form-control {{ $errors->has('start_date') ? 'is-invalid' : '' }}" name="start_date" placeholder="{{ meta('start_date', $lang) ?? __('conferences.start_date') }}" value='{{ old("start_date", $conference->start_date ?? null) }}'/>
            </div>
            <div class="form-group col-lg-6">
                <label>{{ meta('end_date', $lang) ?? __('conferences.end_date') }} </label>
                <input type="date" class="form-control {{ $errors->has('end_date') ? 'is-invalid' : '' }}" name="end_date" placeholder="{{ meta('end_date', $lang) ?? __('conferences.end_date') }}" value='{{ old("end_date", $conference->end_date ?? null) }}'/>
            </div>

            @foreach(languages() as $language)
                <div class="form-group col-lg-12">
                    <label>{{ meta('title', $language->local) ?? __('conferences.title') }} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                    <input type="text" class="form-control {{ $errors->has('title_'.$language->local) ? 'is-invalid' : '' }}" name="title_{{ $language->local }}" placeholder="{{ meta('title', $language->local) ?? __('conferences.title') }}" value='{{ old("title_{$language->local}", $conference[$language->local]->title ?? null) }}'/>
                </div>
                <div class="form-group col-lg-12">
                    <label>{{ meta('description', $language->local) ?? __('conferences.description')}} {{ count($languages) > 1 ? "({$language->name})" : '' }} </label>
                    <textarea rows="5" name="description_{{ $language->local }}" id="description_{{ $language->local }}" class="form-control my-editor {{ $errors->has('description_'.$language->local) ? 'is-invalid' : '' }}" placeholder="{{ meta('description', $language->local) ?? __('conferences.description')}}">{{ old("description_{$language->local}", $conference[$language->local]->description ?? null) }}</textarea>
                </div>
            @endforeach

            {{--Start image container--}}
            <div class="form-group col-lg-12 image_container">
                <label>{{ meta('image', $lang) ?? __('conferences.image') }} </label>
                <input id="image_thumbnail" class="image_thumbnail" type="hidden" name="image" value="{{old("image", $conference->image ?? null)}}"/>

                <div class="photos main_photo {{ old('image', $conference->image ?? '') ? ' wow fadeInUp' : 'hide' }}">
                    <div class="col-md-4">
                        <div class="items">
                            <div class="img">
                                <a href="#" id="lfm" data-input=".image_thumbnail" data-preview=".image_holder" class="lfm" data-hide=".pick_button">
                                    <img src="{{asset(old('image', $conference->image ?? ''))}} "  id="image_holder" class="image_holder"/>
                                </a>
                            </div>
                            <a href="#" class="showHide resetImage close" data-empty=".image_thumbnail" data-hide=".main_photo" data-show=".pick_button"><i class="fas fa-times"></i></a>
                        </div>
                    </div>
                </div>

                <div class="clearfix"></div>
                <span class="input-group-btn pick_button {{ old('image', $conference->image ?? '') ? 'hide' : '' }} ">
                <a id="lfm"  data-input=".image_thumbnail" data-preview=".image_holder" data-show=".main_photo" data-hide=".pick_button" class="lfm btn btn-primary text-light">
                    <i class="fas fa-camera-retro"></i> {{__('dashboard.choose')}}
                </a>
             </span>
            </div>
            {{--End image container--}}


            {{--Start image container--}}
            <div class="border-item photos col-md-12 other_image_container">
                <div class="row">
                    @if (is_array($conference->files ?? []) && count($conference->files ?? []))
                        @foreach ($conference->files as $files)
                            <div class="col-md-4">
                                <div class="items">
                                    <div class="img">
                                        <a href="{{ asset('assets/admin/images/icons/pdf.svg')}}" data-fancybox="gallery"><img src="{{ asset('assets/admin/images/icons/pdf.svg')}}" alt=""></a>
                                    </div>
                                    <input type="hidden" name="files[]" value="{{ $files ?? null }}">
                                    <a href="#" class="close"><i class="fas fa-times"></i></a>
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>
                <div class="text-center">
                    <input id="other_image_thumbnail" class="other_image_thumbnail" type="hidden"/>
                    <div class="clearfix"></div>
                    <span id="add">
                    <a id="lfm" data-type-file="true" data-width="" data-cache="article_gallery" data-input=".other_image_thumbnail" data-preview="" data-show="" data-hide="" class="lfm_file add">
                        {{__('dashboard.add_new_file')}}
                    </a>
                </span>
                </div>
            </div>
            {{--End image container--}}


        <div class="text-center mt-5 col-12">
            <button class="butn add_button"><span>{{ __('dashboard.save') }}</span></button>
        </div>
    </form>
</div>

@endsection

@section('inner_js')

    <!-- Editor JS files -->
    <script src="{{ asset('/assets/admin/js/lib/tinymce.min.js') }}"></script>
    {{--        <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>--}}
    <script>
        let route_prefix = "{{ url(config('lfm.prefix')) }}",
            url = "{{url('/')}}/",
            currentLanguage = "{{$lang}}",
            imageTitle = "{{meta('image_title', $lang) ?? null}}",
            inputName = null,
            thumbnail = "{{asset('assets/admin/images/icons/pdf.svg')}}";
    </script>

    <script src="{{ asset('assets/admin/js/editor.js') }}"></script>
    <script src="{{ asset('assets/admin/js/lfm.js') }}"></script>
    <script src="{{ asset('assets/admin/js/articles.js') }}"></script>

    <script>
        sendAjax('.add_button', '.add_form')
    </script>

@endsection



