<?php

use Illuminate\Database\Seeder;

class ServiceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $images = [
            'assets/web/images/icons/service-1.svg',
            'assets/web/images/icons/service-2.svg',
            'assets/web/images/icons/service-3.svg',
            'assets/web/images/icons/service-4.svg',
            'assets/web/images/icons/service-5.svg',
            'assets/web/images/icons/service-6.svg',
            'assets/web/images/icons/service-7.svg',
            'assets/web/images/icons/service-8.svg',
        ];

        foreach ($images as $image) {

            factory(\App\Service::class)->create(['image' => $image]);
        }

        foreach (languages() as $language) {
            factory(\App\ServiceDescription::class)->create([
                'name' => 'Emergency Medecine',
                'description' => 'All your urgent complains & appointments',
                'service_id' => 1,
                'language_id' => $language->id,
            ]);

            factory(\App\ServiceDescription::class)->create([
                'name' => 'Orthopodic',
                'description' => 'All your urgent complains & appointments',
                'service_id' => 2,
                'language_id' => $language->id,
            ]);

            factory(\App\ServiceDescription::class)->create([
                'name' => 'Ear, Nose, Throat',
                'description' => 'All your urgent complains & appointments',
                'service_id' => 3,
                'language_id' => $language->id,
            ]);

            factory(\App\ServiceDescription::class)->create([
                'name' => 'Emergency Medecine',
                'description' => 'All your urgent complains & appointments',
                'service_id' => 4,
                'language_id' => $language->id,
            ]);

            factory(\App\ServiceDescription::class)->create([
                'name' => 'Cardiology',
                'description' => 'All your urgent complains & appointments',
                'service_id' => 5,
                'language_id' => $language->id,
            ]);

            factory(\App\ServiceDescription::class)->create([
                'name' => 'Neurology',
                'description' => 'All your urgent complains & appointments',
                'service_id' => 6,
                'language_id' => $language->id,
            ]);

            factory(\App\ServiceDescription::class)->create([
                'name' => 'Dermatology',
                'description' => 'All your urgent complains & appointments',
                'service_id' => 7,
                'language_id' => $language->id,
            ]);

            factory(\App\ServiceDescription::class)->create([
                'name' => 'Nephrology',
                'description' => 'All your urgent complains & appointments',
                'service_id' => 8,
                'language_id' => $language->id,
            ]);
        }
    }
}
