<?php

use Illuminate\Database\Seeder;

class PageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        factory(\App\Page::class)->create([
            'images' => [
                'assets/web/images/ab_1.jpg',
                'assets/web/images/ab_2.jpg',
                'assets/web/images/ab_3.jpg',
            ],
            'meta' => ['video' => 'assets/web/images/procare.mp4']
        ]); // [vision]
        factory(\App\Page::class, 2)->create(); // [message, goals]
        factory(\App\Page::class)->create(['image' => 'assets/web/images/icons/feature-1.svg']); // 3 cards in Why us
        factory(\App\Page::class)->create(['image' => 'assets/web/images/icons/feature-2.svg']); // 3 cards in Why us
        factory(\App\Page::class)->create(['image' => 'assets/web/images/icons/feature-3.svg']); // 3 cards in Why us

        /**
         * [
         * Chairman Message
         * Patient Information
         * Patients Services
         * InPatient
         * Nursing
         * Quality Department
         * Accreditation
         * CEO Message
         * ]
         */
        factory(\App\Page::class)->create(['image' => 'assets/web/images/chairman-1.png']);
        factory(\App\Page::class)->create(['images' => ['assets/web/images/accreditation-1.png', 'assets/web/images/accreditation-2.png']]);
        factory(\App\Page::class)->create(['image' => 'assets/web/images/nursing-1.png']);
        factory(\App\Page::class)->create(['image' => 'assets/web/images/nursing-1.png']);
        factory(\App\Page::class)->create(['image' => 'assets/web/images/nursing-1.png']);
        factory(\App\Page::class)->create(['image' => 'assets/web/images/accreditation-2.png']);
        factory(\App\Page::class)->create(['images' => ['assets/web/images/accreditation-1.png', 'assets/web/images/accreditation-2.png']]);
        factory(\App\Page::class)->create(['image' => 'assets/web/images/ceo-1.png']);

        factory(\App\Page::class)->create(); // Board of Directors

        factory(\App\Page::class, 6)->create(); // Home page sections

        factory(\App\Page::class)->create(['image' => 'assets/web/images/accreditation-1.png']); // Pop up
        factory(\App\Page::class, 2)->create(); // Contact us - Working hours
        factory(\App\Page::class, 4)->create(); // Contact us - Working hours - Insurance Partners


        foreach (languages() as $language) {
            // [vision, message, goals]
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Vision',
                'title' => 'Vision',
                'description' => 'Our vision is to become the multi-specialty hospital of choice in Saudi Arabia by adhering to principles of compassionate patient centred care, ensuring a high level of efficiency, quality and safety.',
                'description_2' => 'It Goes Without Saying That The Procare Riaya Hospital Is Committed To Delivering The Highest Quality Healthcare Possible To All Patients Within Our Facilities.',
                'page_id' => 1,
                'language_id' => $language->id,
            ]);
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Mission',
                'title' => 'Our mission is to serve our communities healthcare needs by:',
                'description' => '
                   <ul>
                    <li>
                        Creating a culture of compassionate patient medical care.
                    </li>
                    <li>
                        Adhering to the highest standards of quality, efficiency and safety.
                    </li>
                    <li>
                        Our staff behaving in a manner that ensures our customers have a positive experience.
                    </li>
                    <li>
                        All our actions will result in enhancing shareholder value.
                    </li>
                </ul>
                ',
                'page_id' => 2,
                'language_id' => $language->id,
            ]);
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Values',
                'title' => 'Values',
                'description' => '
                <ul>
                    <li>
                        Corporate social responsibilities.
                    </li>
                    <li>
                        Integrity and ethical practice.
                    </li>
                    <li>
                        Transparency in how we operate while still adhering to highest standards of patient
                    </li>
                    <li>
                        confidentiality.
                    </li>
                    <li>
                        Showing respect for Saudi Arabia`s culture.
                    </li>
                    <li>
                        Excellence by practicing evidence based medicine.
                    </li>
                    <li>
                        Accountable to relevant stakeholders.
                    </li>
                    <li>
                        Rewarding work environment where talented employees thrive.
                    </li>
                    <li>
                        Accountability for our work and prudent services, efficient stewardship for our resources.
                    </li>
                </ul>',
                'page_id' => 3,
                'language_id' => $language->id,
            ]);

            // 3 cards in Why us
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Why us card 1',
                'title' => 'Great Infrastructure',
                'description' => 'Our 100-bedded, well-furnished hospital with technologically well-equipped Diagnostics
center and extraordinary ambience is uniquely positioned in paving the way for a new era
in health care in the region.',
                'page_id' => 4,
                'language_id' => $language->id,
            ]);
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Why us card 2',
                'title' => 'Outstanding, Highly Qualified Doctors',
                'description' => 'An organization is only as good as it\'s people are. No effort has been spared to bring on board
the best of the medical profession across clinical specialties, from around the globe. Our panel of
medical experts have extraordinarily credentialed and defined each doctor`s privileges, ensuring
increased patient safety with the provision of high-quality medical services. The talent pool is
further strengthened by qualified and well-trained nursing and technical professionals. Our
nurses are trained in the latest techniques across various specialties and have implemented
global best practices in caregiving.',
                'page_id' => 5,
                'language_id' => $language->id,
            ]);
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Why us card 3',
                'title' => 'Emergency Support',
                'description' => 'Level-1, 24-Hour Accident & Emergency Centre. A&E is equipped with state-of-the-art
equipment for a wide spectrum of patients with acute emergencies for initial evaluation,
resuscitation, treatment, investigation, stabilisation, monitoring and disposition',
                'page_id' => 6,
                'language_id' => $language->id,
            ]);

            /**
             * [
             * Chairman Message
             * Patient Information
             * Patients Services
             * InPatient
             * Nursing
             * Quality Department
             * Accreditation
             * CEO Message
             * ]
             */
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Chairman Message',
                'title' => 'Turki Al Rajhi',
                'description_2' => 'I hope that you will find the information on our website to be useful in making decisions about your healthcare needs.',
                'description' => '<p>
                                he main aim of Procare hospital is for our patients to experience a culture of compassionate medical care in an environment that makes them feel safe and comfortable. Over the years we have welcomed hundreds of thousands of patients through our doors and conducted thousands of surgeries, during all of this we have been able to maintain our overall patient satisfaction level at an exceptional level of above 90%.
                            </p>
                            <p>
                                Since inception we have been striving to serve our patients in a manner that reflects the highest levels of quality and safety and we have been rewarded in this endeavor by being one of the first in a small group of hospitals in the Eastern Province to be accredited by both the Saudi Central Board for Accreditation of Healthcare Institutions (CBAHI) and the Joint Commission International Accreditation (JCI).
                            </p>
                            <p>
                                Procare is looking forward to the next phase of its’ development and I believe that the 2030 vision for my country provides the healthcare sector an excellent platform to expand and grow. The next few years will see both challenges and opportunities placed on the private sector and surpassing such challenges while maximizing the opportunities will make the nation as a whole stronger.
                            </p>',
                'page_id' => 7,
                'language_id' => $language->id,
            ]);
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Patient Information',
                'title' => 'Patient Information',
                'title_2' => 'Patient Information',
                'description' => 't is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using \'Content here, content here\', making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text,',
                'description_2' => 't is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using \'Content here, content here\', making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text,',
                'page_id' => 8,
                'language_id' => $language->id,
            ]);
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Patients Services',
                'title' => 'Patients Services',
                'description' => '<p>
                                It Goes Without Saying That The Procare Riaya Hospital Is Committed To Delivering The Highest Quality Healthcare Possible To All Patients Within Our Facilities. However, We Are Equally Committed To What Is Inarguably Our Most Valuable Asset – Our Nursing Staff.
                            </p>
                            <p>
                                Our Nursing Practitioners Are From Multicultural Background And Their Vast Experiences Provide Patients At PCRH With Focus On Holistic Care Using The Methodology Of Evidence-Based Practices. We Use Both The Latest Knowledge And Technology To Give You The Care You Deserve As A Patient.

                            </p>
                            <p>
                                Our Department Comprises Professional Staff From Australia, Europe, South Africa, Somalia, The Philippines And India, Providing A Wealth Of International Expertise In Patient Care.
                            </p>
                            <p>
                                Focusing On Patient’s Safety Is A Predominant Attitude Within The Nursing Department; You And Your Relatives Can Be Assured That At Procare Riaya Hospital, You Are In Safe Caring Hands.
                            </p>
                            <p>
                                One Of The Health System’s Primary Goals Is To Maintain Excellent Nursing Services. Our Continuous Nursing Education Department Demonstrates Our Support For The Profession And Our Commitment To Our Entire Nursing Workforce. Our Nurses Provide Outstanding Patient Care, Of Which We Are Justifiably Proud, In An Environment That Supports And Encourages Their Personal And Professional Growth.

                            </p>
                            <p>
                                We Hope That You Will Find This Site A Valuable And Informative Resource And Will Come Back To Visit Regularly For News And Updates As It Continues To Evolve.
                            </p>',
                'page_id' => 9,
                'language_id' => $language->id,
            ]);
            factory(\App\PageDescription::class)->create([
                'page_title' => 'In Patient',
                'title' => 'In Patient',
                'description' => '<p>
                                It Goes Without Saying That The Procare Riaya Hospital Is Committed To Delivering The Highest Quality Healthcare Possible To All Patients Within Our Facilities. However, We Are Equally Committed To What Is Inarguably Our Most Valuable Asset – Our Nursing Staff.
                            </p>
                            <p>
                                Our Nursing Practitioners Are From Multicultural Background And Their Vast Experiences Provide Patients At PCRH With Focus On Holistic Care Using The Methodology Of Evidence-Based Practices. We Use Both The Latest Knowledge And Technology To Give You The Care You Deserve As A Patient.

                            </p>
                            <p>
                                Our Department Comprises Professional Staff From Australia, Europe, South Africa, Somalia, The Philippines And India, Providing A Wealth Of International Expertise In Patient Care.
                            </p>
                            <p>
                                Focusing On Patient’s Safety Is A Predominant Attitude Within The Nursing Department; You And Your Relatives Can Be Assured That At Procare Riaya Hospital, You Are In Safe Caring Hands.
                            </p>
                            <p>
                                One Of The Health System’s Primary Goals Is To Maintain Excellent Nursing Services. Our Continuous Nursing Education Department Demonstrates Our Support For The Profession And Our Commitment To Our Entire Nursing Workforce. Our Nurses Provide Outstanding Patient Care, Of Which We Are Justifiably Proud, In An Environment That Supports And Encourages Their Personal And Professional Growth.

                            </p>
                            <p>
                                We Hope That You Will Find This Site A Valuable And Informative Resource And Will Come Back To Visit Regularly For News And Updates As It Continues To Evolve.
                            </p>',
                'page_id' => 10,
                'language_id' => $language->id,
            ]);
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Nursing',
                'title' => 'Nursing',
                'description' => '<p>
                                    It Goes Without Saying That The Procare Riaya Hospital Is Committed To Delivering The Highest Quality Healthcare Possible To All Patients Within Our Facilities. However, We Are Equally Committed To What Is Inarguably Our Most Valuable Asset – Our Nursing Staff.
                                </p>
                                <p>
                                    Our Nursing Practitioners Are From Multicultural Background And Their Vast Experiences Provide Patients At PCRH With Focus On Holistic Care Using The Methodology Of Evidence-Based Practices. We Use Both The Latest Knowledge And Technology To Give You The Care You Deserve As A Patient.

                                </p>
                                <p>
                                    Our Department Comprises Professional Staff From Australia, Europe, South Africa, Somalia, The Philippines And India, Providing A Wealth Of International Expertise In Patient Care.
                                </p>
                                <p>
                                    Focusing On Patient’s Safety Is A Predominant Attitude Within The Nursing Department; You And Your Relatives Can Be Assured That At Procare Riaya Hospital, You Are In Safe Caring Hands.
                                </p>
                                <p>
                                    One Of The Health System’s Primary Goals Is To Maintain Excellent Nursing Services. Our Continuous Nursing Education Department Demonstrates Our Support For The Profession And Our Commitment To Our Entire Nursing Workforce. Our Nurses Provide Outstanding Patient Care, Of Which We Are Justifiably Proud, In An Environment That Supports And Encourages Their Personal And Professional Growth.

                                </p>
                                <p>
                                    We Hope That You Will Find This Site A Valuable And Informative Resource And Will Come Back To Visit Regularly For News And Updates As It Continues To Evolve.
                                </p>',
                'page_id' => 11,
                'language_id' => $language->id,
            ]);
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Quality Department',
                'title' => 'Procare Quality Department',
                'description' => '
                    <p>
                        Be Treated With Respect And Dignity Regardless Of Nationality, Color, Age, Gender, Religion, And Physical Infirmity Or Condition (If Any).
                    </p>
                    <p>
                        Receive Reasonable Safety And Security.
                        Know The Identity And Professional Status Of The Care Team And Be Informed In Case There Are Trainees In The Care Team.
                        Receive Accurate And Understandable Health Information About His/Her Diagnosis And Treatment Plan, The Reasons Of Each Treatment Or Test Or Procedure That Will Be Done And Whom It Will Be Done By. Have The Right To Answer All His/Her Questions In A Language That The Patient Understands, And The Right To Be Provided A Translator If Necessary.
                    
                    </p>
                    <p>
                        Know The Nature Of Their Situation, Illness, Procedure, Proposed Treatment, Benefits, Risks, Expected Cost Of Any Procedure,  Any Possible Alternative, For One To Make A Decision That Affects Any One Of These Elements Before Signing An Informed Consent.
                  
                    </p>
                    <p>
                        Refuse Signing The Consent Form For Any Test Or Procedure And The Right To Revoke And Change His/Her Mind Regarding Any Consent Form For Any Procedure And Test Though Previously Consented To.
                    </p>
                ',
                'page_id' => 12,
                'language_id' => $language->id,
            ]);
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Accreditation',
                'title' => 'Accreditation Message',
                'title_2' => 'Accreditation Message',
                'description' => 't is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using \'Content here, content here\', making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text,',
                'description_2' => 't is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using \'Content here, content here\', making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text,',
                'page_id' => 13,
                'language_id' => $language->id,
            ]);
            factory(\App\PageDescription::class)->create([
                'page_title' => 'CEO Message',
                'description' => 'It Goes Without Saying That The Procare Riaya Hospital Is Committed To Delivering The Highest Quality Healthcare Possible To All Patients Within Our Facilities. However, We Are Equally Committed To What Is Inarguably Our Most Valuable Asset – Our Nursing Staff.',
                'page_id' => 14,
                'language_id' => $language->id,
            ]);

            // Board of Directors
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Meet Our Board',
                'title' => 'Meet Our Board',
                'description' => 'It Goes Without Saying That The Procare Riaya Hospital Is Committed To Delivering The Highest Quality Healthcare Possible To All Patients Within Our Facilities. However,',
                'page_id' => 15,
                'language_id' => $language->id,
            ]);

            // Home page sections
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Home page Services section',
                'title' => 'We Provide a multiple Services',
                'description' => 'Procare Riaya Hospital is a private Riaya Hospital is a private hospital jointly owned by Mr. AbdulRahman Al Rajhi & Partners Co. Ltd.',
                'page_id' => 16,
                'language_id' => $language->id,
            ]);
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Home page number section',
                'title' => 'Honored to mention Some numbers',
                'description' => 'Procare Riaya Hospital is a private hospital jointly owned by Mr. AbdulRahman Al Rajhi & Partners Co. Ltd.',
                'page_id' => 17,
                'language_id' => $language->id,
            ]);
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Home page doctor section',
                'title' => 'Get to know our Doctors',
                'description' => 'Professinal doctors to help you know more informations about them',
                'page_id' => 18,
                'language_id' => $language->id,
            ]);
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Home page news section',
                'title' => 'Watch out our latest News',
                'description' => 'Here\'s our latest news from our blog',
                'page_id' => 19,
                'language_id' => $language->id,
            ]);
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Home page about us section',
                'title' => 'Get to know Procare',
                'description' => '<p>
                                Procare Riaya Hospital is a private hospital jointly owned by Mr. AbdulRahman Al Rajhi & Partners Co. Ltd. It promises to provide comprehensive health care services to its local community and become a major referral and treatment center for patients throughout the Eastern Province of the Kingdom.
                            </p>
                            <p>
                                Our 100 bed, high technology healthcare center staffed by highly qualified and motivated physicians is paving the way for a new era in health care in the region.
                            </p>',
                'page_id' => 20,
                'language_id' => $language->id,
            ]);
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Footer',
                'description' => 'Procare Riaya Hospital is a private hospital jointly owned by Mr. AbdulRahman Al Rajhi & Partners Co. Ltd. It promises to provide comprehensive health care services to its local community and become a major referral and treatment center for patients throughout the Eastern Province of the Kingdom.

Our 100 bed, high technology healthcare center staffed by highly qualified and motivated physicians is paving the way for a new era in health care in the region.',
                'page_id' => 21,
                'language_id' => $language->id,
            ]);
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Pop up',
                'title' => 'Title Write Here',
                'description' => 'Lorem ipsum dolor, sit amet consectetur adipisicing elit. Laborum consequatur deserunt at nostrum beatae quae cumque perferendis, repellat consequuntur libero a! Est aut tempora possimus enim harum molestiae nihil eius. Lorem ipsum dolor, sit amet consectetur adipisicing elit. Laborum consequatur deserunt at nostrum beatae quae cumque perferendis, repellat consequuntur libero a! Est aut tempora possimus enim harum molestiae nihil eius.',
                'page_id' => 22,
                'language_id' => $language->id,
            ]);

            factory(\App\PageDescription::class)->create([
                'page_title' => 'Contact us',
                'title' => 'Keep in touch with Procare',
                'description' => 'Procare Riaya Hospital is a private hospital jointly owned by Mr. AbdulRahman Al Rajhi & Partners Co. Ltd. It promises to provide comprehensive health care services.',
                'page_id' => 23,
                'language_id' => $language->id,
            ]);

            factory(\App\PageDescription::class)->create([
                'page_title' => 'Working Hours',
                'title' => ' Working hours are 24 hours, 7 days a week.',
                'description' => null,
                'page_id' => 24,
                'language_id' => $language->id,
            ]);
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Insurance Partners',
                'title' => 'Insurance Partners',
                'description' => 'Here\'s our dear people we\'s dea testmonials from dear people we\'s dea our dear people we\'s deal with procare through years',
                'page_id' => 25,
                'language_id' => $language->id,
            ]);
            factory(\App\PageDescription::class)->create([
                'page_title' => 'Conference section (home page)',
                'title' => 'Health Conferences',
                'description' => 'Here\'s our latest news from our blog',
                'page_id' => 26,
                'language_id' => $language->id,
            ]);


        }
    }
}
