<?php

use Illuminate\Database\Seeder;

class DoctorSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $images = [
            'assets/web/images/dr-1.JPG',
            'assets/web/images/dr-2.JPG',
            'assets/web/images/dr-3.JPG',
            'assets/web/images/dr-4.JPG',
        ];

        foreach ($images as $image) {
            factory(\App\Doctor::class)->create(['image' => $image]);
        }


        foreach (\App\Doctor::cursor() as $doctor) {
            foreach (languages() as $language) {
                factory(\App\DoctorDescription::class)->create([
                    'doctor_id' => $doctor->id,
                    'language_id' => $language->id,
                ]);
            }

        }

    }
}
