<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEducationDescriptionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('education_descriptions', function (Blueprint $table) {
            $table->id();
            $table->string('name', 50);

            $table->unsignedBigInteger('education_id');
            $table->unsignedBigInteger('language_id');

            $table->foreign('education_id')->references('id')->on('educations')->cascadeOnDelete();

            $table->index(['education_id', 'language_id']);
            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('education_descriptions');
    }
}
