<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDoctorDescriptionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('doctor_descriptions', function (Blueprint $table) {
            $table->id();
            $table->string('name', 100)->nullable();
            $table->text('specialist')->nullable();
//            $table->text('certifications')->nullable();
//            $table->text('trainings')->nullable();
//            $table->text('experiences')->nullable();
//            $table->text('researches')->nullable();
//            $table->text('professional_memberships')->nullable();
            $table->longText('details')->nullable();

            $table->unsignedBigInteger('doctor_id')->index();
            $table->unsignedBigInteger('language_id')->index();

            $table->foreign('doctor_id')->references('id')->on('doctors')->cascadeOnDelete();

            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('doctor_descriptions');
    }
}
