<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDoctorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('doctors', function (Blueprint $table) {
            $table->id();
            $table->boolean('show_in_chairman')->default(1);
            $table->boolean('show_in_home')->index()->default(1);
            $table->boolean('show_in_offers')->default(1);
            $table->unsignedBigInteger('category_id')->index()->nullable();
            $table->float('discount_percentage')->nullable();
            $table->string('facebook', 300)->nullable();
            $table->string('twitter', 300)->nullable();
            $table->string('instagram', 300)->nullable();
            $table->string('linkedin', 300)->nullable();
            $table->string('okadoc_url', 300)->nullable();
            $table->string('image', 200)->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('doctors');
    }
}
