<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePartnerDescriptionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('partner_descriptions', function (Blueprint $table) {
            $table->id();
            $table->string('name',100);
//            $table->string('slug',100)->nullable();
//            $table->text('meta_description');
//            $table->string('keywords',400);
//            $table->longText('description');

            $table->unsignedBigInteger('partner_id')->index();
            $table->unsignedBigInteger('language_id')->index();
            $table->foreign('partner_id')->references('id')->on('partners')->cascadeOnDelete();

            // Set engine to InnoDB it's useful in join and constraint
            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('partner_descriptions');
    }
}
