<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePageDescriptionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('page_descriptions', function (Blueprint $table) {
            $table->id();
            $table->string('page_title', 50)->nullable();
            $table->string('title', 100)->nullable();
            $table->string('title_2', 100)->nullable();
            $table->longText('description')->nullable();
            $table->longText('description_2')->nullable();

            $table->unsignedBigInteger('page_id')->index();
            $table->unsignedBigInteger('language_id')->index();

            $table->foreign('page_id')->references('id')->on('pages')->cascadeOnDelete();

            // Set engine to InnoDB it's useful in join and constraint
            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('page_descriptions');
    }
}
