<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */

use App\Language;
use App\VideoCategory;
use App\VideoCategoryDescription;
use Faker\Generator as Faker;

$factory->define(VideoCategoryDescription::class, function (Faker $faker) {
    return [
        'name' => $faker->name,
        'slug' => $faker->unique()->slug(2),
        'keywords' => $faker->unique()->sentence,
        'meta_description' => $faker->sentence,
        'video_category_id' => factory(VideoCategory::class)->create()->id,
        'language_id' => Language::firstOrCreate(['local'=> getCurrentLocale(), 'name'=> \LaravelLocalization::getCurrentLocaleName()])->id,
    ];
});
