<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */

use App\CareerApplication;
use Faker\Generator as Faker;

$factory->define(CareerApplication::class, function (Faker $faker) {
    return [
        'name' => $faker->name('male'),
        'country_id' => $faker->randomElement(\App\Country::pluck('id')->toArray()),
        'education_id' => $faker->randomElement(\App\Education::pluck('id')->toArray()),
        'service_id' => $faker->randomElement(\App\Service::pluck('id')->toArray()),
//        'submission_date' => date('Y-m-d'),
        'phone' => $faker->e164PhoneNumber,
        'birth_date' => $faker->date(),
        'address' => $faker->address,
        'cv' => $faker->randomElement(['assets/admin/images/logo.png', 'assets/admin/images/605e619417c0e.pdf']),
    ];
});
