<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * @property mixed doctor_ids
 */
class Service extends Model
{
    use SoftDeletes;

    protected $fillable = ['image', 'doctor_ids'];

    protected $casts = [
        'doctor_ids' => 'array'
    ];

    public function careerApplications()
    {
        return $this->hasMany(CareerApplication::class);
    }


    public function careers()
    {
        return $this->hasMany(Career::class);
    }

    /**
     * Get description for pages
     * @return HasMany
     */
    public function descriptions() :HasMany
    {
        return $this->hasMany(ServiceDescription::class);
    }

    /**
     * Get description of current language for pages
     * @return HasOne
     */
    public function currentDescription() :HasOne
    {
        return $this->hasOne(ServiceDescription::class)->where('language_id', currentLanguage()->id);
    }

    public static function withDescription($id = null, $limit = null, $random = false)
    {
        $query = self::join('service_descriptions as sDesc', 'sDesc.service_id', 'services.id')
            ->where('sDesc.language_id', currentLanguage()->id);

        if ($id){
            $query->where('services.id', $id);
        }

        if ($limit){
            $query->limit($limit);
        }

        if ($random){
          $query->inRandomOrder();
        }

        $query->select([
            'services.id',
            'services.image',
            'services.doctor_ids',
            'sDesc.name',
            'sDesc.description'
        ]);

        return $id ? $query->first() : $query->cursor();
    }


}
