<?php

namespace App\Http\Middleware;
use Closure;
use Illuminate\Support\Facades\App;
use Illuminate\Auth\Middleware\Authenticate as Middleware;

class Httpscheck extends Middleware
{
    /**
     * Redirect user to Arabic route 
     *
     * @param  \Illuminate\Http\Request  $request
     * @return string|null
     */
    public function handle($request, Closure $next)
    {
        if (!$request->secure() && App::environment() == 'local') 
        {
            return redirect()->secure($request->getRequestUri());
        }

        return $next($request); 
    }
}