<?php

namespace App\Http\Controllers\Web;

use App\Article;
use App\Category;
use App\Http\Controllers\Controller;
use App\Page;
use App\PhotoCategory;
use App\Slider;
use Illuminate\View\View;


class ProductController extends Controller
{
    private $view = 'web.products.';

    /**
     * Show the application dashboard.
     * @return View
     */
    public function index(): View
    {
        $pages = Page::withDescription([3]);
        $pageImage = asset($pages->image);
        $title = $pages->title ?? __('main.products');
        $banner = Slider::withDescription(null, [5]);

        $flavors = Article::withDescription();
        return view($this->view.'index', get_defined_vars());
    }

}
