<?php

namespace App\Http\Controllers\Web;

use App\Article;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\View\View;


class NewsController extends Controller
{
    private $view = 'web.news.';

    /**
     * Show the application dashboard.
     * @return View
     */
    public function index(): View
    {
        $news = Article::withDescription([], 7);
        $title = __('articles.medical_topics');
        $firstNew = $news->first();
       return view($this->view.'index', get_defined_vars());
    }

    public function show(Article $new)
    {
        $new = Article::withDescription([$new->id]);
        $title = __('articles.news_details');
        return view($this->view.'show', get_defined_vars());
    }

    public function seeMore(Request $request)
    {
        if ($request->ajax()){
            $news = Article::withDescription([], 7, $request->skip);
            return view($this->view.'see_more', get_defined_vars());
        }
    }
}
