<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Contracts\View\Factory;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;

/**
 * @property array weekDates
 */
class DashboardController extends Controller
{

    private $months = [];
    private $monthByNumbers = [];
    private $monthByNames = [];
    private $translatedMonths = [];

    public function __construct()
    {
        $date = \Illuminate\Support\Carbon::make(date('Y').'-12-1');
        $months = [];
        $monthByNumbers = [];
        $monthByNames = [];
        $translatedMonths = [];

        for ($i = 1; $i <= 12; $i++){
            $x = $date->addMonth();
            $month = $x->englishMonth;
            $months[] = $month;
            $monthByNumbers[] = $i;
            $monthByNames[$i] = $x->englishMonth;
            $translatedMonths[$i] = $x->getTranslatedMonthName();
        }

        $this->months = $months;
        $this->monthByNumbers = $monthByNumbers;
        $this->monthByNames = $monthByNames;
        $this->translatedMonths = $translatedMonths;

    }

    /**
     * Show the stats of the website.
     * @return Factory|View
     */

    public function index() :View
    {
        $title = __('dashboard.dashboard');

        $months = json_encode($this->months);

        $startYear = Carbon::now()->addYears(-7);
        $lastYear = Carbon::now();

        $startMonth = Carbon::now()->addMonths(-7);
        $lastMonth = Carbon::now();

        $startWeek = Carbon::now()->addWeeks(-7);
        $lastWeek = Carbon::now();


        $yearVisitors = DB::table('website_visitors')
            ->orderBy('created_at', 'asc')
            ->whereBetween('created_at', [$startYear, $lastYear])
            ->selectSub("YEAR(created_at)", 'yearsCount')
            ->get()->groupBy('yearsCount')->toArray();

        $yearsData = [];
        $yearsAxis = [];
        $monthsData = [];
        $monthsAxis = [];
        $weeksData = [];
        $weeksAxis = [];

        foreach ($yearVisitors as $year => $yearVisitor) {
            $yearsData[] = count($yearVisitor);
            $yearsAxis[] = $year;
        }

        $yearsData = json_encode($yearsData);
        $yearsAxis = json_encode($yearsAxis);

        $monthVisitors = DB::table('website_visitors')
            ->orderBy('created_at', 'asc')
            ->whereBetween('created_at', [$startMonth, $lastMonth])
            ->selectSub("MONTH(created_at)", 'monthCount')
            ->get()->groupBy('monthCount')->toArray();

        foreach ($monthVisitors as $monthNumber => $monthVisitor) {
            $monthsData[] = count($monthVisitor);
            $monthsAxis[] = $this->translatedMonths[$monthNumber];
        }


        $monthsData = json_encode($monthsData);
        $monthsAxis = json_encode($monthsAxis);


        $weekVisitors = DB::table('website_visitors')
            ->orderBy('created_at', 'asc')
            ->whereBetween('created_at', [$startWeek, $lastWeek])
            ->selectSub("WEEK(created_at)", 'weekCount')
            ->get()->groupBy('weekCount')->toArray();

        foreach ($weekVisitors as $weekNumber => $weekVisitor) {
            $weeksData[] = count($weekVisitor);
            $weeksAxis[] = $weekNumber;
        }

        $weeksData = json_encode($weeksData);
        $weeksAxis = json_encode($weeksAxis);


        $doctors = DB::table('doctors')->whereNull('deleted_at')->count();
        $directors = DB::table('directors')->whereNull('deleted_at')->count();
        $careers = DB::table('careers')->whereNull('deleted_at')->count();
        $careerApplications = DB::table('career_applications')->whereNull('deleted_at')->count();

        return view('admin.index', get_defined_vars());
    }
}
