<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * @property mixed id
 * @mixin Builder
 */
class Gallery extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'type',
        'image',
        'video_url',
    ];


    public static function withDescription($type = null, $ids = [], $notIn = [])
    {
        $query = self::join('gallery_descriptions as galleryDesc', 'galleryDesc.gallery_id', 'galleries.id')
            ->where('galleryDesc.language_id', currentLanguage()->id);

        if ($type){
            $query->where('galleries.type', $type);
        }

        if (count($ids)){
            $query->whereIn('galleries.id', $ids);
        }

        $query->select(['galleries.*', 'galleryDesc.title']);

        return count($ids) == 1 ? $query->first() : $query->get();
    }

}
