<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;


class Education extends Model
{

    use SoftDeletes;

    protected $table = 'educations';
    /**
     * Get description for pages
     * @return HasMany
     */
    public function descriptions() :HasMany
    {
        return $this->hasMany(EducationDescription::class);
    }

    /**
     * Get description of current language for pages
     * @return HasOne
     */
    public function currentDescription() :HasOne
    {
        return $this->hasOne(EducationDescription::class)->where('language_id', currentLanguage()->id);
    }



    public static function withDescription($education_id = null)
    {
        $educations = self::join('education_descriptions as cd', 'cd.education_id', 'educations.id')
            ->where('cd.language_id', currentLanguage()->id);

        if($education_id){
            $educations->where('educations.id', $education_id);
        }

        $educations->select([
            'educations.*',
            'cd.name',
        ]);
        return $education_id ? $educations->first() : $educations->cursor() ?? [];
    }

}
