<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class CareerApplication
 * @package App
 * @mixin Builder
 */
class CareerApplication extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'name',
        'career_id',
        'country_id',
        'education_id',
        'service_id',
        'submission_date',
        'phone',
        'birth_date',
        'address',
        'cv',
    ];

    public function career()
    {
        return $this->belongsTo(Career::class);
    }
}
