<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ArticlePhoto extends Model
{
    public $timestamps = false;

    protected $fillable = ['image', 'article_id'];


    /**
     * Return article for article image
     * @return BelongsTo
     */
    public function article() :BelongsTo
    {
        return $this->belongsTo(Article::class);
    }
}
