@extends('admin.layouts.container')

@section('content')
    <div class="row">

        @foreach ($yearChart as $count)
            <input type="hidden" name="{{$loop->iteration}}" value="{{$count}}" class="yearVisitCounts">
        @endforeach

        @foreach ($monthChart as $month => $count)
            <input type="hidden" name="{{$month}}" value="{{$count}}" class="monthVisitCounts">
        @endforeach

        @foreach ($weekChart as $month => $count)
            <input type="hidden" name="{{$month}}" value="{{$count}}" class="weekVisitCounts">
        @endforeach



    <!-- ------------ line chart ------------- -->
        {{--    <input type="hidden" value="{{$yearVisitorCounts}}" class="allVisitorCounts">--}}
        <!--<div class="col-lg-12">-->
        <!--    <h5 class="text-uppercase font-weight-bold">{{__('dashboard.view_in_year')}}</h5>-->
        <!--    <canvas class="border-item lineChart" width="400" height="150"></canvas>-->
        <!--</div>-->

        {{--    <div class="col-lg-6">--}}
        {{--        <div class="new-users border-item">--}}
        {{--            <div class="datatitle">--}}
        {{--                <h6>The proportion of new users</h6>--}}
        {{--                <p>2019-06-13 ~ 2019-06-19 | Last 7 days</p>--}}
        {{--            </div>--}}
        {{--            <div class="chartjs-wrapper"><iframe class="chartjs-hidden-iframe" tabindex="-1" style="display: block; overflow: hidden; border: 0px; margin: 0px; top: 0px; left: 0px; bottom: 0px; right: 0px; height: 100%; width: 100%; position: absolute; pointer-events: none; z-index: -1;"></iframe>--}}
        {{--                <canvas id="chartjs-4" class="chartjs" width="962" height="550" style="display: block; height: 500px; width: 770px;"></canvas>--}}
        {{--            </div>--}}
        {{--        </div>--}}
        {{--    </div>--}}


        <div class="col-lg-6 mb-3">
            <div class="new-users border-item">
                <div class="datatitle">
                    <h6 class="text-uppercase font-weight-bold">{{__('dashboard.view_in_year')}} ({{date('Y')}})</h6>
                    <!--<p>{{__('dashboard.year')}}: {{date('Y')}}</p>-->
                </div>

                <div class="items">
                <span class="number text-primary">
                    @php
                        /** @var TYPE_NAME $yearVisitorCounts */
                        $percentage = $yearVisitorCounts ? ($yearVisitorCounts*100)/$yearVisitorCounts . '%' : '0 %';
                    @endphp
                    {{$yearVisitorCounts}}
                </span>
                    <div class="progress-item">
                        <p class="info"> {{__('dashboard.visits')}} </p>
                        <div class="progress"><span class="bg-primary" data-value="{{$percentage}}"></span></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-6 mb-3">
            <div class="new-users border-item">
                <div class="datatitle">
                    <h6 class="text-uppercase font-weight-bold">{{__('dashboard.view_in_month')}} ({{date('F')}})</h6>
                    <p>{{__('dashboard.month')}}: {{date('m')}}</p>
                </div>

                <div class="items">
                <span class="number text-primary">
                    @php
                        /** @var TYPE_NAME $monthChart */
                        /** @var TYPE_NAME $yearVisitorCounts */
                        $month = date('n');
                        $count = $monthChart[$month] ?? 0;
                        $percentage = $count ? ($count*100)/$yearVisitorCounts . '%' : '0 %';
                    @endphp
                    {{$count}}
                </span>
                    <div class="progress-item">
                        <p class="info"> {{__('dashboard.visits')}} </p>
                        <div class="progress"><span class="bg-primary" data-value="{{$percentage}}"></span></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-6 mb-3">
            <div class="new-users border-item">
                <div class="datatitle">
                    <h6 class="text-uppercase font-weight-bold">{{__('dashboard.view_in_week')}} ({{date('W')}})</h6>
                    <p>{{__('dashboard.week')}}: {{date('W')}}</p>
                </div>

                <div class="items">
                <span class="number text-primary">
                    @php
                        /** @var TYPE_NAME $weekVisitorCounts */
                        $percentage = $weekVisitorCounts ? ($weekVisitorCounts*100)/$weekVisitorCounts . '%' : '0 %';
                    @endphp
                    {{$weekVisitorCounts}}
                </span>
                    <div class="progress-item">
                        <p class="info"> {{__('dashboard.visits')}} </p>
                        <div class="progress"><span class="bg-primary" data-value="{{$percentage}}"></span></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-6 mb-3">
            <div class="new-users border-item">
                <div class="datatitle">
                    <h6 class="text-uppercase font-weight-bold">{{__('dashboard.view_in_day')}} ({{date('l')}})</h6>
                    <p>{{__('dashboard.day')}}: {{date('F')}}</p>
                </div>

                <div class="items">
                <span class="number text-primary">
                    @php
                        /** @var TYPE_NAME $dayVisitCounts */
                        $percentage = $dayVisitCounts ? ($dayVisitCounts*100)/$dayVisitCounts . '%' : '0 %'
                    @endphp
                    {{$dayVisitCounts}}
                </span>
                    <div class="progress-item">
                        <p class="info"> {{__('dashboard.visits')}} </p>
                        <div class="progress"><span class="bg-primary" data-value="{{$percentage}}"></span></div>
                    </div>
                </div>
            </div>
        </div>
            <div class="col-lg-6 mb-3">
                <div class="new-users border-item">
                    <div class="datatitle">
                        <h6 class="text-uppercase font-weight-bold">{{__('careers.head')}}</h6>
                    </div>

                    <div class="items">
                        <span class="number text-primary">{{$careers}}</span>
                        <div class="progress-item">
                            <p class="info"> {{__('careers.job')}} </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 mb-3">
                <div class="new-users border-item">
                    <div class="datatitle">
                        <h6 class="text-uppercase font-weight-bold">{{__('careerApplications.head')}}</h6>
                    </div>

                    <div class="items">
                        <span class="number text-primary">{{$careerApplications}}</span>
                        <div class="progress-item">
                            <p class="info"> {{__('careerApplications.application')}} </p>
                        </div>
                    </div>
                </div>
            </div>

        {{--    <div class="col-lg-6 mb-3">--}}
        {{--        <div class="new-users border-item">--}}
        {{--            <div class="datatitle">--}}
        {{--                <h6 class="text-uppercase font-weight-bold">{{__('dashboard.clients_counts')}}</h6>--}}
        {{--            </div>--}}

        {{--            <div class="items">--}}
        {{--            <span class="number text-primary">{{$clientCounts}}</span>--}}
        {{--                <div class="progress-item">--}}
        {{--                    <p class="info"> {{__('dashboard.client')}} </p>--}}
        {{--                </div>--}}
        {{--            </div>--}}
        {{--        </div>--}}
        {{--    </div>--}}
        {{--    <div class="col-lg-6 mb-3">--}}
        {{--        <div class="new-users border-item">--}}
        {{--            <div class="datatitle">--}}
        {{--                <h6 class="text-uppercase font-weight-bold">{{__('dashboard.sales_revenue')}}</h6>--}}
        {{--            </div>--}}

        {{--            <div class="items">--}}
        {{--                <span class="number text-primary">{{$revenueTotal}}</span>--}}
        {{--                <div class="progress-item">--}}
        {{--                    <p class="info"> {{__('dashboard.sar')}} </p>--}}
        {{--                </div>--}}
        {{--            </div>--}}
        {{--        </div>--}}
        {{--    </div>--}}

        {{--    <div class="col-md-12 mt-5">--}}
        {{--        <table class="table table-bordered shadow">--}}
        {{--            <thead>--}}
        {{--            <tr>--}}
        {{--                <td colspan="3" class="card-header text-center">--}}
        {{--                    <h5 class="text-uppercase font-weight-bold">Most viewed articles</h5>--}}
        {{--                </td>--}}
        {{--            </tr>--}}
        {{--            <tr class="bg-dark text-white">--}}
        {{--                <th style="width: 10%" class="text-center">Serial</th>--}}
        {{--                <th>Article title</th>--}}
        {{--                <th style="width: 15%" class="text-center">Visited count</th>--}}
        {{--            </tr>--}}
        {{--            </thead>--}}
        {{--            <tbody>--}}
        {{--            @foreach ($articles as $article)--}}
        {{--                <tr>--}}
        {{--                    <td class="text-center">{{$loop->iteration}}</td>--}}
        {{--                    <td>{{$article->title}}</td>--}}
        {{--                    <td>{{$article->visit_counts}}</td>--}}
        {{--                </tr>--}}
        {{--            @endforeach--}}

        {{--            </tbody>--}}
        {{--        </table>--}}
        {{--    </div>--}}


    </div>
@endsection

@section('inner_js')
    {{--<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.3/Chart.min.js"></script>--}}
    <script src="{{asset('assets/admin/js/lib/Chart.min.js')}}"></script>
    <script>
        $(document).ready(function () {
            let years = [],
                year_visits = [],
                months = [],
                month_visits = [],
                weeks = [],
                week_visits = [],
                ChartHtml = $('.lineChart').html('2d');

            $('.yearVisitCounts').each(function () {
                years.push($(this).attr('name'));
                year_visits.push($(this).val());
            });

            $('.monthVisitCounts').each(function () {
                months.push($(this).attr('name'));
                month_visits.push($(this).val());
            });

            $('.weekVisitCounts').each(function () {
                weeks.push($(this).attr('name'));
                week_visits.push($(this).val());
            });

            // month_visits.push(allVisitorCounts);

            new Chart(ChartHtml, {
                type: 'line',
                data: {
                    labels: years,
                    datasets: [
                        {
                            label: ' Year',
                            data: year_visits,
                            backgroundColor: [
                                'rgba(255, 99, 132, 0.2)',
                                'rgba(54, 162, 235, 0.2)',
                                'rgba(255, 206, 86, 0.2)',
                                'rgba(75, 192, 192, 0.2)',
                                'rgba(153, 102, 255, 0.2)',
                                'rgba(255, 159, 64, 0.2)'
                            ],
                            borderColor: [
                                'rgba(255, 99, 132, 1)',
                                'rgba(54, 162, 235, 1)',
                                'rgba(255, 206, 86, 1)',
                                'rgba(75, 192, 192, 1)',
                                'rgba(153, 102, 255, 1)',
                                'rgba(255, 159, 64, 1)'
                            ],
                            borderWidth: 1
                        },
                        {
                            label: ' Month',
                            data: month_visits,
                            backgroundColor: [
                                'rgba(255, 99, 132, 0.2)',
                                'rgba(54, 162, 235, 0.2)',
                                'rgba(255, 206, 86, 0.2)',
                                'rgba(75, 192, 192, 0.2)',
                                'rgba(153, 102, 255, 0.2)',
                                'rgba(255, 159, 64, 0.2)'
                            ],
                            borderColor: [
                                'rgba(255, 99, 132, 1)',
                                'rgba(54, 162, 235, 1)',
                                'rgba(255, 206, 86, 1)',
                                'rgba(75, 192, 192, 1)',
                                'rgba(153, 102, 255, 1)',
                                'rgba(255, 159, 64, 1)'
                            ],
                            borderWidth: 1
                        },
                        {
                            label: ' Week',
                            data: week_visits,
                            backgroundColor: [
                                'rgba(255, 99, 132, 0.2)',
                                'rgba(54, 162, 235, 0.2)',
                                'rgba(255, 206, 86, 0.2)',
                                'rgba(75, 192, 192, 0.2)',
                                'rgba(153, 102, 255, 0.2)',
                                'rgba(255, 159, 64, 0.2)'
                            ],
                            borderColor: [
                                'rgba(255, 99, 132, 1)',
                                'rgba(54, 162, 235, 1)',
                                'rgba(255, 206, 86, 1)',
                                'rgba(75, 192, 192, 1)',
                                'rgba(153, 102, 255, 1)',
                                'rgba(255, 159, 64, 1)'
                            ],
                            borderWidth: 1
                        }
                    ]
                },
                options: {
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero: true
                            }
                        }]
                    }
                }
            });
        })
    </script>


    {{--<script>--}}
    {{--    new Chart(document.getElementById("chartjs-4"), {--}}
    {{--        "type": "doughnut",--}}
    {{--        "data": {--}}
    {{--            "labels": ["completed Profiles", "uncompleted Profiles", "waiting Approval"],--}}
    {{--            "datasets": [{--}}
    {{--                "label": "My First Dataset",--}}
    {{--                "data": [180, 90, 120],--}}
    {{--                "backgroundColor": ["rgb(33, 255, 13)", "rgb(220, 53, 69)", "rgb(21, 97, 203)"]--}}
    {{--            }]--}}
    {{--        }--}}
    {{--    });--}}
    {{--</script>--}}

@endsection
