@extends('web.layouts.container')

@section('content')
    <section class="services-sec section pb-0">
        <div class="container">
            <div class="service_card text-center col-lg-6 m-auto mb-5">
                <img src="{{asset($service->image ?? 'assets/web/images/logo.svg')}}" alt="" class="icon m-auto mb-3"/>
                <h3 class="title fs-3 mb-3 color-dark fw-bold">{{$service->name}}</h3>
                <p class="det">{{$service->description}}</p>

            </div>
        </div>
    </section>
    <!-- Start doctors-pg -->
    @if(count($doctors))
    <section class="doctors-pg section pt-2">
        <div class="container">
            <div class="text-center mb-5">
                <h6 class="subtitle color-primary mb-3 text-uppercase">{{__('main.expert_doctors')}}</h6>
                <h1 class="title text-center fw-bold color-dark text-capitalize">{{__('main.meet_doctors')}}</h1>
            </div>

            <div class="swiper-container serv_dr_swiper">
                <div class="swiper-wrapper pb-0">

                        @foreach($doctors as $doctor)
                        <div class="swiper-slide">
                            <div class="dr_card wow fadeInUp">
                                <div class="img-box">
                                    <img src="{{asset($doctor->image)}}" alt="" class="sec-img"/>
                                </div>
                                <div class="card-body">
                                    <h4 class="name mb-3">{{$doctor->name}}</h4>
                                    <p class="job">{{$doctor->specialist}}</p>
                                    <a target="_blank" href="{{$settings['booking_appointment_url']}}" class="butn primary_butn">{{__('main.make_appointment')}}</a>
                                </div>
                            </div>
                        </div>
                        @endforeach

                </div>
                <div class="swiper-pagination"></div>
            </div>
        </div>
    </section>
    @endif
@endsection

@section('inner_js')
    <script>
        var swiper = new Swiper('.doctors-pg .serv_dr_swiper', {
            // loop: true,
            speed: 900,
            slidesPerView: 1,
            spaceBetween: 10,
            // centeredSlides: true,
            // autoplay: {
            //     delay: 2500,
            // },
            navigation: {
                nextEl: '.doctors-pg .swiper-button-next',
                prevEl: '.doctors-pg .swiper-button-prev',
            },
            pagination: {
                el: '.doctors-pg .swiper-pagination',
                clickable: true
            },
            breakpoints: {
                640: {
                    slidesPerView: 2,
                    spaceBetween: 20,
                },
                768: {
                    slidesPerView: 3,
                    spaceBetween: 20,
                },
                1024: {
                    slidesPerView: 4,
                    spaceBetween: 20,
                },
            }
        });
    </script>
@endsection
