@extends('web.layouts.container')

@section('content')
    <section class="services-sec section services-pg">
        <div class="container">
            <div class="sec-head mb-5 text-center">
                <h2 class="title fw-bold color-dark mb-4">
                    {{$pageTitle1}} <span class="color-primary">{{$pageTitle2}}</span>
                </h2>
                <p class="p col-lg-6 m-auto">{!! $page[0]->description !!}</p>
            </div>
            <div class="row justify-content-center">
                @if(count($services))
                    @foreach($services as $service)
                        <div class="col-lg-3">
                            <div class="service_card {{$loop->odd && $loop->iteration <= 4 ? 'bg-babyBlue' : ($loop->even && $loop->iteration > 4 ? 'bg-babyBlue' : '')}} wow left_to_right_apperance">
                                <img src="{{asset($service->image ?? 'assets/web/images/logo.svg')}}" alt="" class="icon"/>
                                <h5 style="word-break: break-all" class="title color-dark fw-bold">{{wordLimit($service->name, 2)}}</h5>
                                <p class="det">{{wordLimit($service->description, 6)}}</p>
                                <a href="{{route('service.show', $service->id)}}" class="more_butn mt-4">
                                    <img src="{{asset('assets/web/images/icons/right-arrow.svg')}}" alt="" class="icon_arrow"/>
                                </a>
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>
        </div>
        <img src="{{asset('assets/web/images/pattern-2.png')}}" alt="" class="pattern"/>
    </section>
    <section class="partners-sec clients-sec section wow left_to_right_apperance">
        <div class="container">
            <div class="sec-head mb-5 col-lg-5">
                <h1 class="title color-dark fw-bold mb-4 ">
                    {{$insurancePartnerTitle1}} <span class="color-primary">{{$insurancePartnerTitle2}}</span>
                </h1>
                <p class="p">{!! $insurancePartnerPage->description !!}</p>
            </div>
            <div class="swiper-container clients-swiper">
                <div class="swiper-wrapper">
                    @if(count($insurancePartners))
                        @foreach($insurancePartners as $insurancePartner)
                            <div class="swiper-slide">
                                <a target="_blank" href="{{$insurancePartner->url}}">
                                    <img src="{{asset($insurancePartner->image)}}" alt="" class="partner_logo"/>
                                </a>
                            </div>
                        @endforeach
                    @endif
                </div>
            </div>
        </div>
    </section>

@endsection

@section('inner_js')
    <script>

    </script>
@endsection
