@extends('web.layouts.layout')

@section('container_content')
    <main>
        @include('web.layouts.nav')
        @if(\Illuminate\Support\Facades\Route::currentRouteName() == 'home')
            @include('web.layouts.home_header')
        @else
            @include('web.layouts.page_header')
        @endif
        @yield('content')
        @include('web.layouts.footer')
    </main>
@endsection

@section('container_js')
    <script>
        axios.defaults.headers.common = {
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-TOKEN' : document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        };
    </script>
    <script src="{{ asset('assets/web/js/actions.js') }}"></script>
    @yield('inner_js')
@endsection
