@extends('web.layouts.container')
@section('css')
    <style>
        .accreditation-pg .inner {
            min-height: 350px;
        }
        .accreditation-pg .inner .text-box {
            z-index: 6;
            background: linear-gradient(to right, #192D6A , #2e4589, transparent);
        }
        .accreditation-pg .inner .text-box .title {
            text-shadow: 3px 6px 10px #0005;
        }
        .accreditation-pg .inner .text-box .det {
            text-shadow: 3px 6px 10px #0003;
        }
        .dr_card .badge {
            position: absolute;
            top: 0;
            right: 0;
            padding: 0.5rem 1rem;
            font-size: 12px;
            font-weight: bold;
            border-radius: 0;
            background-color: var(--secondary);
            color: #fff;
        }
    </style>
@endsection
@section('content')
    <section class="offers-pg section bg-babyBlue" >
        <div class="container">
            <!-- Tabs -->
            <div class="media-pg">
                <ul class="nav nav-pills mb-5" id="pills-tab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active category_id" data-category="1" id="pills-tab1-tab" data-bs-toggle="pill" data-bs-target="#pills-tab1" type="button" role="tab" aria-controls="pills-tab1" aria-selected="true">
                            <img src="{{asset('assets/web/images/icons/offers-1.png')}}" alt="" class="icon"/> {{__('banners.category_1')}}
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link category_id" data-category="2" id="pills-tab2-tab" data-bs-toggle="pill" data-bs-target="#pills-tab2" type="button" role="tab" aria-controls="pills-tab2" aria-selected="false">
                            <img src="{{asset('assets/web/images/icons/offers-2.png')}}" alt="" class="icon"/>  {{__('banners.category_2')}}
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link category_id" data-category="3" id="pills-tab3-tab" data-bs-toggle="pill" data-bs-target="#pills-tab3" type="button" role="tab" aria-controls="pills-tab3" aria-selected="false">
                            <img src="{{asset('assets/web/images/icons/offers-3.png')}}" alt="" class="icon"/>  {{__('banners.category_3')}}
                        </button>
                    </li>
                </ul>
            </div>
            <div class="content_container">
                <!-- Banner -->
                <div class="accreditation-pg mb-5 ">
                    <div class="inner bg-white mb-0 wow left_to_right_apperance">
                        <div class="row align-items-center">
                            <div class="col-lg-6">
                                <div class="text-box zi-5">
                                    <div class="head mb-0">
                                        <h6 class="color-secondary mb-3">
                                            @if($lang == 'en')
                                                {{__('banners.category_1') . ' ' . __('banners.offers_title')}}
                                            @endif
                                            @if($lang == 'ar')
                                                    {{__('banners.offers_title') . ' ' .__('banners.category_1')}}
                                            @endif
                                        </h6>
                                        <h1 class="title color-dark text-white fw-bold mb-4">{{$banner->title}}</h1>
                                        <p class="det text-white">
                                            {{stripText($banner->description)}}
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 order_sm_1">
                            </div>
                        </div>
                        <img src="{{asset($banner->image)}}" alt="" class="bg"/>
                    </div>
                </div>
                <!-- Cards -->
                <div class="doctors-pg">
                    <div class="row">
                        @if(count($doctors))
                            @foreach($doctors as $doctor)
                                <div class="col-lg-3 col-md-6">
                                    <div class="dr_card wow fadeInUp">
                                        <div class="img-box">
                                            <img src="{{asset($doctor->image)}}" alt="" class="sec-img"/>
                                            <span class="badge">{{$doctor->discount_percentage}}% {{__('banners.discount')}}</span>
                                        </div>
                                        <div class="card-body">
                                            <h4 class="name mb-3">{{$doctor->name}}</h4>
                                            <p class="job">{{$doctor->specialist}}</p>
                                            @if($doctor->okadoc_url)
                                            <a target="_blank" href="{{$doctor->okadoc_url}}" class="butn primary_butn">{{__('main.make_appointment')}}</a>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('inner_js')
    <script>

        let getOfferRoute = "{{route('banner.index')}}";

        $('.category_id').click(async function (e) {
            e.preventDefault();

            $(this).prop('disabled', true);

            let data = {category_id: $(this).data('category')},
                url = getOfferRoute,
                method = 'get';

            const response=await ajax({
                url,
                data,
                dataType: 'html',
                method
            });

            if (response){
                $(this).prop('disabled', false);
                $('.content_container').html(response);
            }

        });
    </script>
@endsection
