@extends('web.layouts.container')
@section('css')
    <link rel="stylesheet" href="{{ asset('assets/web/css/pages_style.css') }}" />
@endsection
@section('content')
    <section class="about-pg about-sec section">
        <div class="container">
            <h1 class="title mb-5">{{$visionPage->title}}</h1>
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <img src="{{asset($visionPage->image)}}" alt="" class="sec-img"/>
                </div>
                <div class="col-lg-6">
                    <div class="text-box">
                        <ul class="custom_ul col-lg-11">
                            @if(is_array($visionPage->meta) && count($visionPage->meta))
                                @foreach($visionPage->meta['titles'][$lang] as $meta)
                                    <li class="li">{{$meta}} </li>
                                @endforeach
                            @endif
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Start banner-sec -->
    <section class="banner-sec section mt-5 mb-5">
        <div class="container">
            <div class="text-center py-5">
                <p class="text-white fs-3 col-lg-10 m-auto about_det">{{$briefPage->description}}</p>
            </div>
        </div>
        <img src="{{asset($briefPage->image)}}" alt="" class="bg"/>
    </section>
@endsection

@section('inner_js')
    <script>
        $('.navbar').addClass('navbar-light white-nav');
        $(document).find('header img.bg').attr('style', 'object-position: top;');
    </script>
@endsection
